/*
 * XXXX 
 *
 * Fecha 14/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet.presentacion.corredores;

import java.util.ArrayList;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejie.p06b.datatype.logic.P06BCorredor;
import com.ejie.p06b.datatype.logic.P06BCorredorListasAux;
import com.ejie.p06b.datatype.logic.P06BError;
import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.datatype.model.P06B22T00Datatype;
import com.ejie.p06b.datatype.model.P06B25T00Datatype;
import com.ejie.p06b.datatype.model.P06B26T00Datatype;
import com.ejie.p06b.datatype.model.P06B27T00Datatype;
import com.ejie.p06b.datatype.model.P06B28T00Datatype;
import com.ejie.p06b.datatype.model.P06B29T00Datatype;
import com.ejie.p06b.datatype.model.P06B30T00Datatype;
import com.ejie.p06b.datatype.model.P06B24T00Datatype;
import com.ejie.p06b.datatype.model.P06B60T00Datatype;
import com.ejie.p06b.datatype.model.P06B61T00Datatype;
import com.ejie.p06b.datatype.model.P06B64T00Datatype;
import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.manager.P06BGeneralManager;
import com.ejie.p06b.p06bMediadoresSegurosEJB.P06BMediadoresSegurosEJB;
import com.ejie.p06b.p06bMediadoresSegurosEJB.P06BMediadoresSegurosEJBHome;

import com.ejie.p06b.servlet.P06BServletGenerico;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.P06BFieldsValidations;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.util.P06BResources;

/**
 *  Esta clase gestiona las peticiones HTTP de la aplicacin.
 */
public class P06BAtencionPeticionesCorrelativoServlet extends P06BServletGenerico 
{

	//Cambia de idioma en la sesin -> Perfil
	public void ejecutar(HttpServletRequest request, HttpServletResponse response) {
		try {
			P06B64T00Datatype datosAtencionPeticion = this.obtener(request,response);
			if (request.getParameter("accion").equals("consulta")){
				//Redireccionamos a la pgina de consulta de atencion de peticin
				request.getSession().removeAttribute(P06BConstantes.P06B_VAR_TEMP+"objetivo"+P06BConstantes.P06B_VAR_TEMP_FILTRO);
				request.getSession().setAttribute(P06BConstantes.P06B_VAR_TEMP+"AtencionPeticionModificar",datosAtencionPeticion);
				forward (request, response, P06BPaginas.P06B_JSP_ATENCIONPETICIONES_MODIFICAR);
			}else if (request.getParameter("accion").equals("revision")){
				request.getSession().setAttribute("AtencionPeticionEnRevision",datosAtencionPeticion);
				String destino = "/" + P06BPaginas.P06B_JSP_SERVLETCORREDORMODIFICAR_INJSP + "?Expedi=" + datosAtencionPeticion.getExpediente() + "&accion=cambio";
				forward (request, response, destino);
			}
		}catch (Exception e){
	      	manejarErrores (request, response, e);
	        return;
	    }
	}
	
	//Obtengo las provincias, municipios, localidades y CP's
	//Ojo, en este caso obtengo del atributo de la request 
	private void obtenerFCAs2(HttpServletRequest request, HttpServletResponse response) throws Exception {
		P06B20T00Datatype vo = (P06B20T00Datatype)request.getSession().getAttribute(P06BConstantes.P06B_VAR_TEMP+"Corredor");
		ArrayList listaProvincias = P06BGeneralManager.getInstance().obtenerProvincias(this.getIdioma(request,response));
		request.setAttribute("listaProvincias",listaProvincias);
		if(!vo.getCodpro().equals("")){
			ArrayList listaMunicipios = P06BGeneralManager.getInstance().obtenerMunicipios(Integer.parseInt(vo.getCodpro()));
			request.setAttribute("listaMunicipios",listaMunicipios);
			if(!vo.getCodmun().equals("")){
				ArrayList listaLocalidades = P06BGeneralManager.getInstance().obtenerLocalidades(
						Integer.parseInt(vo.getCodpro()),Integer.parseInt(vo.getCodmun()));
				request.setAttribute("listaLocalidades",listaLocalidades);
				if(!vo.getLocali().equals("")){
					ArrayList listaCP = P06BGeneralManager.getInstance().obtenerCodPostales(
							Integer.parseInt(vo.getCodpro()),
							Integer.parseInt(vo.getCodmun()),
							Integer.parseInt(vo.getLocali()));
					request.setAttribute("listaCP",listaCP);
				}
			}
		}
	}
	
	//Obtengo el corredor de la B.D. y lo meto en la request
	private P06B64T00Datatype obtener(HttpServletRequest request, HttpServletResponse response) throws Exception {
		boolean retorno = true;
		if (request.getParameter("correlativo")==null || request.getParameter("correlativo").trim().equals("")){
			retorno = false;
//			return retorno; 
		}
        P06B64T00Datatype datosAtencionPeticiones = null;
        datosAtencionPeticiones = P06BCorredoresManager.getInstance().selectDatosAtencPeticTramitagune(Integer.parseInt(request.getParameter("correlativo")));
        
//		return retorno;
        return datosAtencionPeticiones;
	}
	
	
	private ArrayList insertaError(ArrayList errors, String nombreCampo, String codigo) {
	 	P06BError error = new P06BError();
		error.setNombreCampo(nombreCampo);
		error.setCodigo(codigo);
		errors.add(error);
		return errors;
	}
	
}